VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "WinWedge sample for Visual Basic"
   ClientHeight    =   5790
   ClientLeft      =   1500
   ClientTop       =   555
   ClientWidth     =   6315
   LinkTopic       =   "Form1"
   ScaleHeight     =   5790
   ScaleWidth      =   6315
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame Frame3 
      Caption         =   "Serial output data (to WinWedge)"
      Height          =   1455
      Left            =   120
      TabIndex        =   9
      Top             =   4320
      Width           =   6015
      Begin VB.CommandButton btnTransmit 
         Caption         =   "Transmit"
         Height          =   375
         Left            =   2280
         TabIndex        =   11
         Top             =   840
         Width           =   1935
      End
      Begin VB.TextBox Text5 
         Height          =   375
         Left            =   240
         TabIndex        =   10
         Top             =   360
         Width           =   5535
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "WinWedge launch parameters:"
      Height          =   2655
      Left            =   120
      TabIndex        =   2
      Top             =   240
      Width           =   6015
      Begin VB.ComboBox Combo1 
         Height          =   315
         ItemData        =   "Form1.frx":0000
         Left            =   240
         List            =   "Form1.frx":0010
         Style           =   2  'Dropdown List
         TabIndex        =   12
         Top             =   2040
         Width           =   1215
      End
      Begin VB.TextBox Text2 
         Height          =   360
         Left            =   240
         TabIndex        =   5
         Text            =   "Text2"
         Top             =   615
         Width           =   5535
      End
      Begin VB.TextBox Text3 
         Height          =   360
         Left            =   240
         TabIndex        =   4
         Text            =   "Text3"
         Top             =   1320
         Width           =   5535
      End
      Begin VB.CommandButton btnLaunch 
         Caption         =   "Launch WinWedge"
         Height          =   375
         Left            =   2160
         TabIndex        =   3
         Top             =   2040
         Width           =   1935
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "File Path to WinWedge.exe:"
         Height          =   195
         Left            =   240
         TabIndex        =   8
         Top             =   360
         Width           =   1995
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "WinWedge configuration file path:"
         Height          =   195
         Left            =   240
         TabIndex        =   7
         Top             =   1080
         Width           =   2415
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "Comm port:"
         Height          =   195
         Left            =   240
         TabIndex        =   6
         Top             =   1800
         Width           =   795
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Serial input data (from WinWedge)"
      Height          =   975
      Left            =   120
      TabIndex        =   0
      Top             =   3120
      Width           =   6015
      Begin VB.TextBox Text1 
         ForeColor       =   &H00000000&
         Height          =   345
         Left            =   240
         LinkItem        =   "field(1)"
         LinkTopic       =   "WinWedge|Com2"
         TabIndex        =   1
         Top             =   360
         Width           =   5535
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Sub btnLaunch_Click()
CloseWedge          ' if wedge already loaded then kill it
Sleep (3)           ' wait 3 seconds
LaunchWedge         ' launch WinWedge
End Sub
Private Sub btnTransmit_Click()
' if we have an open DDE link to the Wedge for the textbox text1
' and there is data in the text box text5 then send it out the port.
If (Text1.LinkMode <> 0) And Len(Text5.Text) Then
  ' If the string that you want to send out the serial port contains
  ' control characters then you issue the "Sendout" command to the Wedge
  ' to transmit the string. The syntax for the Sendout command
  ' requires the string to be converted to a sequence of ASCII values
  ' for all control codes. The function "ConvertString" converts
  ' the string to one that is compatible with the Sendout command.
  ' In this case, you would use the following code to use the Sendout command.
  ' First convert our string to make it compatible with the Sendout command
  StringToSend$ = ConvertString(Text5.Text)
  ' Issue the Sendout command with the converted string
  Text1.LinkExecute "[SENDOUT(" & StringToSend$ & ")]"
  ' If the string that you want to transmit contains no control codes
  ' then you do not need to convert the string and can simply
  ' issue the "Send" dde command to the Wedge.
  ' The Send command transmits simple text strings out the serial port.
  ' In this case, you could use the following line to transmit your string.
  ' >>> Text1.LinkExecute "[Send(" & Text5.Text & ")]" <<<
Else
  Beep
End If
End Sub
Function ConvertString(StringToConvert$) As String
' The following loop reads the StringToConvert$ variable and generates a string containing
' the ASCII values for each character in the string separated by commas.
' This resulting string is then used as the argument to the SENDOUT command below.
' Ex: if the variable StringToConvert$ = "ABC" then the variable Arg$ will be "65,66,67"
' See the syntax of the SENDOUT command in the Wedge users manual for details.
For x = 1 To Len(StringToConvert$)
 ' build a string consisting of ASCII character values seperated by commas
 Arg$ = Arg$ + Format$(Asc(Mid$(StringToConvert$, x, 1)))   ' get ASCII values
 If x <> Len(StringToConvert$) Then Arg$ = Arg$ + ","       ' add commas between them
Next
ConvertString = Arg$    ' return the resulting converted string.
End Function
Private Sub Form_Load()
'Define defaults for Software Wedge program file, configuration file, COM port,
'link topic and link item - MODIFY THESE TO MATCH YOUR OWN SYSTEM !
Combo1.ListIndex = 1    ' set COM1 as the default
Text2.Text = "C:\WinWedge\WinWedge.exe"
Text3.Text = "C:\WinWedge\TEST.SW1"

'If you have modified the above lines to match the file locations on your
'system, you may wish to un-comment the following line so that the Wedge is
'launched automatically when the form is loaded - note that an error will
'result if the following line is un-commented and the program file or
'configuration file is not found.
'LaunchWedge                   ' Launch the Wedge
End Sub
Private Sub Form_Unload(Cancel As Integer)
CloseWedge   ' if wedge is loaded then kill it
End Sub
Private Sub Text1_LinkNotify()
' This is where we retrieve the data from the Wedge
' Whenever the Wedge receives a new serial data record,
' it causes a LinkNotify event in the DDE linked text box.
' We have to perform a LinkRequest to get the data
' from the Wedge into the text box.

' We could have used an Automatic link so that the data from the
' Wedge would automatically be updated in the text box.
' In that case we would have also used the Change event for the
' linked text box to signal when a new data record has been received.
' This technique works just fine however the change event for the text
' box does not fire if two consecutive data records are received
' containing the same data.

' To avoid this problem we use a link mode of vbLinkNotify.
' This causes VB to generate a LinkNotify event for the text box
' whenever the Wedge receives a new data record - even if it is
' the same data as the previous data record.

Text1.LinkRequest 'retrieve the data from the Wedge to the text box

' You would put additional code here to do something with the data
Beep    ' make some noise maybe?

End Sub
Private Sub Sleep(Seconds As Integer)
'Idles for 0 to 59 seconds
Dim Secs As Integer, EndTime As Date
Select Case Seconds
    Case Is < 0: Secs = 0
    Case Is > 59: Secs = 59
    Case Else: Secs = Seconds
End Select
EndTime = Now + TimeValue("00:00:" & Format$(Secs, "00"))
Do
    DoEvents
Loop Until Now >= EndTime
End Sub
Private Sub LaunchWedge()
'Try to launch the Software Wedge
On Error Resume Next        ' ignore errors
If Len(Combo1.Text) < 4 Then
  MsgBox "Please select a Communications port."
  Combo1.SetFocus
  Combo1.SelStart = 0
  Combo1.SelLength = Len(Combo1.Text)
  Exit Sub
End If
If Len(Dir$(Text3.Text)) = 0 Then
  MsgBox "Cannot find the specified Software Wedge configuration file."
  Text3.SetFocus
  Text3.SelStart = 0
  Text3.SelLength = Len(Text3.Text)
  Exit Sub
End If
x = Shell(Text2.Text + " " + Text3.Text)
If x = 0 Then
  MsgBox "Cannot find WinWedge.exe using the specified file path."
  Text2.SetFocus
  Text2.SelStart = 0
  Text2.SelLength = Len(Text2.Text)
  Exit Sub
End If
' Note: The Shell statement above launches the Software Wedge
' using the specified file path in Text2 and it also passes
' the configuration file specified in Text3 on the command line.
' This causes the Wedge to automatically load the configuration file
' and activate itself with that config file.

' The Shell statement launches the Wedge and returns immediately.
' At this point, the Wedge has been launched
' however it is not fully loaded into memory therefore it may not be
' ready to establish a DDE connection back to this program.
' Therefore, we must wait for the Wedge to load completely.
' The following code shows two different techniques that you can use
' to wait for the Wedge to load. The first simply waits for a few
' seconds to give the Wedge time to load and the second keeps
' trying to establish a DDE connection with the Wedge until
' it is successful.

' First, set the link topic and the link item properties of Text1
' to the values required to establish a link with WinWedge
Text1.LinkTopic = "WinWedge|" + Combo1.Text ' Set link topic to "WinWedge|COMn"
Text1.LinkItem = "Field(1)"                ' Set link item to Field(1)


'Option 1 - use a delay to allow Software Wedge time to load
'Sleep (3)                          ' wait for three seconds
'Text1.LinkMode = vbLinkNotify      ' set the link mode to "Notify"
'Text1.LinkExecute "[appminimize]"  ' Minimize Software Wedge window

'Option 2 - Use error trapping to determine when Wedge has loaded
' this option returns much faster than the previous technique
WaitTime = Now + TimeValue("00:00:05") '
Do                          ' Loop while error occurs
    DoEvents
    Err.Number = 0                 ' reset Err object
    Text1.LinkMode = vbLinkNotify   ' set the linkmode to "Notify"
    If Now >= WaitTime Then
      MsgBox "A timeout occurred while trying to connect to WinWedge. Check that the specified COM port is correct."
      Exit Sub
    End If
Loop While Err.Number = 282         ' if error occurs - try again

Text1.LinkExecute "[appminimize]"   ' Minimize Software Wedge window

End Sub
Private Sub CloseWedge()
If Text1.LinkMode Then  ' Tell the Wedge to remove itself from memory
    Text1.LinkExecute "[AppExit]"   ' Issue "Appexit" command to Wedge
    Text1.LinkMode = vbLinkNone     ' Reset link mode to 0
End If
End Sub

