Imports System.Text
Imports NDde.Client

Public Class MainForm
    Private WithEvents client As DdeClient

    Private Sub client_Advise(ByVal sender As Object, ByVal e As NDde.Client.DdeAdviseEventArgs) Handles client.Advise
        ' this subroutine runs each time the specified DDE Server data item is updated
        txtDDEData.Text = e.Text                        ' put the data received from the server in txrDDEData textbox
        displayTextbox.Text = "OnAdvise: " + e.Text     ' update the Status textbox
    End Sub

    Private Sub client_Disconnected(ByVal sender As Object, ByVal e As NDde.Client.DdeDisconnectedEventArgs) Handles client.Disconnected
        ' update the Status textbox showing that the server is disconnected
        displayTextbox.Text = _
         "OnDisconnected: " + _
         "IsServerInitiated=" + e.IsServerInitiated.ToString() + " " + _
         "IsDisposed=" + e.IsDisposed.ToString()
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        displayTextbox.Text = ""
        Try
            ' if this is the first time through then the client object has not been created
            ' and the following code will throw an error - just ignore the error
            If client.IsConnected Then client.Disconnect()
        Catch
        End Try

        Try
            ' Connect to the server.  It must be running or an exception will be thrown.
            client = New DdeClient(txtDDEServer.Text, txtDDETopic.Text, Me)
            client.Connect()
            displayTextbox.Text = "Connected"           ' update the Status textbox indicating that we are connected
            ' start Advise Loop
            client.StartAdvise(txtDDEItem.Text, 1, True, 60000)
        Catch ex As Exception
            displayTextbox.Text = ex.Message            ' oops - an error occurred - show the cause of the error in the Status textbox
        End Try

    End Sub
    Private Sub OnExecuteComplete(ByVal ar As IAsyncResult)
        ' this subroutine runs when a DDE command is sent using the Asynchronous Execute
        ' this lets you know that the DDE Command was processed - this code is not used in this example
        ' instead, we use a Synchronous Execute where the command is send and is assumed to be processed
        Static x As Long = 0
        x += 1
        Try
            Dim client As DdeClient = DirectCast(ar.AsyncState, DdeClient)
            client.EndExecute(ar)
            displayTextBox.Text = "OnExecuteComplete " + x.ToString
        Catch e As Exception
            displayTextBox.Text = "OnExecuteComplete: " + x.ToString + " " + e.Message
        End Try
    End Sub

   
    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Try
            ' Asynchronous Execute Operation
            'client.BeginExecute(txtCommand.Text, AddressOf OnExecuteComplete, client)

            ' Synchronous Execute Operation - send the DDE command 
            client.Execute(txtCommand.Text, 1000)

        Catch ex As Exception
            displayTextbox.Text = "Command execution failed "
        End Try

    End Sub

    
   
End Class
